#include <openssl/x509AT.h>
#include <openssl/x509v3.h>

int X509AT_sign(X509AT *x, EVP_PKEY *pkey, const EVP_MD *md)
	{
	return ASN1_sign((int (*)())i2d_X509AT_CINF, x->cert_info_at->signature,\
		x->sig_alg, x->signature,(char *) x->cert_info_at,pkey,md);
	}

/*GENERAL_NAME *GENERAL_NAME_dup(GENERAL_NAME *gn)
	{
	GENERAL_NAME *gntemp;
	char *cadenatmp;
	int len1,i;

	gntemp=GENERAL_NAME_new();
	len1=i2d_GENERAL_NAME(gn,NULL);

	cadenatmp=(unsigned char *)OPENSSL_malloc(len1);

	for (i=0;i<len1;i++)
		{
		cadenatmp[i]=0;
		}

	len1=i2d_GENERAL_NAME(gn,&cadenatmp);

	gntemp=d2i_GENERAL_NAME(&gntemp,&cadenatmp,len1);

	return gntemp;
	}
*/

/***************************************************************************

BEGIN_ANYADIDO por mi 30/04/2003

***************************************************************************/


int X509AT_set_version(X509AT *x, long version)
	{
	if (x == NULL) return(0);
	if (x->cert_info_at->version == NULL)
		{
		if ((x->cert_info_at->version=M_ASN1_INTEGER_new()) == NULL)
			return(0);
		}
	return(ASN1_INTEGER_set(x->cert_info_at->version,version));
	}

int X509AT_set_serialNumber(X509AT *x, ASN1_INTEGER *serial)
	{
	ASN1_INTEGER *in;

	if (x == NULL) return(0);
	in=x->cert_info_at->serialNumber;
	if (in != serial)
		{
		in=M_ASN1_INTEGER_dup(serial);
		if (in != NULL)
			{
			M_ASN1_INTEGER_free(x->cert_info_at->serialNumber);
			x->cert_info_at->serialNumber=in;
			}
		}
	return(in != NULL);
	}

int X509AT_set_notBefore(X509AT *x, ASN1_TIME *tm)
//int X509AT_set_notBeforeTime(X509AT *x, ASN1_GENERALIZEDTIME *tm)
	{
	ASN1_GENERALIZEDTIME *in;

	if ((x == NULL) || (x->cert_info_at->attrCertValidityPeriod == NULL)) return(0);
	in=x->cert_info_at->attrCertValidityPeriod->notBeforeTime;
	if (in != tm)
		{
		in=M_ASN1_GENERALIZEDTIME_dup(tm);
		if (in != NULL)
			{
			M_ASN1_GENERALIZEDTIME_free(x->cert_info_at->attrCertValidityPeriod->notBeforeTime);
			x->cert_info_at->attrCertValidityPeriod->notBeforeTime=in;
			}
		}
	return(in != NULL);
	}

int X509AT_set_notAfter(X509AT *x, ASN1_TIME *tm)
//int X509AT_set_notAfterTime(X509AT *x, ASN1_GENERALIZEDTIME *tm)
	{
	ASN1_GENERALIZEDTIME *in;

	if ((x == NULL) || (x->cert_info_at->attrCertValidityPeriod == NULL)) return(0);
	in=x->cert_info_at->attrCertValidityPeriod->notAfterTime;
	if (in != tm)
		{
		in=M_ASN1_GENERALIZEDTIME_dup(tm);
		if (in != NULL)
			{
			M_ASN1_GENERALIZEDTIME_free(x->cert_info_at->attrCertValidityPeriod->notAfterTime);
			x->cert_info_at->attrCertValidityPeriod->notAfterTime=in;
			}
		}
	return(in != NULL);
	}



int X509AT_V2FORM_set(X509AT_V2FORM **xn, X509AT_V2FORM *name)
/********FALTA************/
	{
/*	X509_NAME *in;

	if (!xn || !name) return(0);

	if (*xn != name)
		{
		in=X509_NAME_dup(name);
		if (in != NULL)
			{
			X509_NAME_free(*xn);
			*xn=in;
			}
		}
	return(*xn != NULL);
*/	
	return -1;
	}

int X509AT_ATTCERTISSUER_set(X509AT_ATTCERTISSUER **xn, X509AT_ATTCERTISSUER *name)
/********FALTA************/
	{
/*	X509_NAME *in;

	if (!xn || !name) return(0);

	if (*xn != name)
		{
		in=X509_NAME_dup(name);
		if (in != NULL)
			{
			X509_NAME_free(*xn);
			*xn=in;
			}
		}
	return(*xn != NULL);
*/	
	return -1;
	}


int X509AT_HOLDER_set(X509AT_HOLDER **xn, X509AT_HOLDER *name)
/********FALTA************/
	{
/*	X509_NAME *in;

	if (!xn || !name) return(0);

	if (*xn != name)
		{
		in=X509_NAME_dup(name);
		if (in != NULL)
			{
			X509_NAME_free(*xn);
			*xn=in;
			}
		}
	return(*xn != NULL);
*/	
	return -1;
	}

int X509AT_set_attcertissuer(X509AT *x, X509AT_ATTCERTISSUER *issuer)
	{
	if ((x == NULL) || (x->cert_info_at == NULL)) return(0);
	return(X509AT_ATTCERTISSUER_set(&x->cert_info_at->issuer,issuer));
	}

int X509AT_set_holder(X509AT *x, X509AT_HOLDER *holder)
	{
	if ((x == NULL) || (x->cert_info_at == NULL)) return(0);
	return(X509AT_HOLDER_set(&x->cert_info_at->holder,holder));
	}
	

/**************************************************************************************/

int X509AT_issuer_and_serial_cmp(const X509AT *a, const X509AT *b)
	{
	int i;


	X509AT_CINF *ai,*bi;
	if (!a || !b)
		return -1;

	ai=a->cert_info_at;
	bi=b->cert_info_at;
	i=M_ASN1_INTEGER_cmp(ai->serialNumber,bi->serialNumber);
	if (i) return(i);
	return(X509AT_ATTCERTISSUER_cmp(ai->issuer,bi->issuer));
	}


int ASN1_OBJECT_cmp (const ASN1_OBJECT *a,const ASN1_OBJECT *b)
	{

	/* Si alguno es NULL se devuelve -1*/
	if (!a || !b)
		return -1;

	/* Si los nid's son distintos se devuelve 1*/
	if ( OBJ_obj2nid(a) != OBJ_obj2nid(b) )
		return 1;

	/* Si los nid's son iguales, se devuelve 0*/
	return 0;
	}

int EDIPARTYNAME_cmp(const EDIPARTYNAME *a,const EDIPARTYNAME *b)
	{
	if (!a || !b)
		return -1;

	if (ASN1_STRING_cmp(a->nameAssigner,b->nameAssigner))
		return 1;

	if (ASN1_STRING_cmp(a->partyName,b->partyName))
		return 1;

	return 0;
	}

int OTHERNAME_cmp (const OTHERNAME *a,const OTHERNAME *b)
	{
	if (!a || !b)
		return -1;

	if (ASN1_OBJECT_cmp(a->type_id,b->type_id))
		return 1;

	if (ASN1_TYPE_cmp(a->value,b->value))
		return 1;

	return 0;
	}

int GENERAL_NAME_cmp(const GENERAL_NAME *a,const  GENERAL_NAME *b)
	/*
	 Devuelve 0 en caso de exito
	*/
	{
	if (!a || !b)
		return -1;

	if (a->type != b->type)	
		return 1;

	switch (a->type)
		{
		case GEN_OTHERNAME:	{
							return OTHERNAME_cmp((a->d).otherName,(b->d).otherName);
							};break;
		case GEN_EDIPARTY:	{
							return EDIPARTYNAME_cmp((a->d).ediPartyName,(b->d).ediPartyName);
							};break;
		case GEN_DIRNAME:	{
							return X509_NAME_cmp((a->d).directoryName,(b->d).directoryName);
							};break;
		case GEN_X400:		{
							return ASN1_TYPE_cmp((a->d).x400Address,(b->d).x400Address);
							};break;
		case GEN_RID:		{
							return ASN1_OBJECT_cmp((a->d).registeredID,(b->d).registeredID);
							};break;
		case GEN_EMAIL:		{
							return ASN1_STRING_cmp((a->d).rfc822Name,(b->d).rfc822Name);
							};break;
		case GEN_DNS:		{
							return ASN1_STRING_cmp((a->d).dNSName,(b->d).dNSName);
							};break;
		case GEN_URI:		{
							return ASN1_STRING_cmp((a->d).uniformResourceIdentifier,(b->d).uniformResourceIdentifier);
							};break;
		case GEN_IPADD:		{
							return ASN1_STRING_cmp((a->d).iPAddress,(b->d).iPAddress);
							};break;
		default:{
				return -1;
				}

		}
	}

int GENERAL_NAMES_cmp(const GENERAL_NAMES *a,const GENERAL_NAMES *b)
	/*
	 Compara las dos stacks para ver si son completamente iguales 
	*/
	{
	int i;

	if (!a || !b)
		return -1;

	if (sk_num(a) != sk_num(b))
		return 1;

	for (i=0;i<sk_num(a);i++)
		{
		if(GENERAL_NAME_cmp((GENERAL_NAME *)sk_value(a,i),(GENERAL_NAME *)sk_value(b,i)) !=0)
			{
			return 1;
			}
		}

	return 0;
	}

int ASN1_TYPE_cmp (const ASN1_TYPE *a, const ASN1_TYPE *b)
	{
	if (a->type!=b->type)
		{
		return b->type - a->type;
		}

	switch (a->type)
		{
		case V_ASN1_BOOLEAN:{
							return (a->value).boolean!=(b->value).boolean;
							};break;
		case V_ASN1_OBJECT:{
							return ASN1_OBJECT_cmp((a->value).object,(b->value).object);
							};break;
		case V_ASN1_INTEGER:{
							return ASN1_STRING_cmp((a->value).integer,(b->value).integer);
							};break;
		case V_ASN1_ENUMERATED:{
							return ASN1_STRING_cmp((a->value).enumerated,(b->value).enumerated);
							};break;
		case V_ASN1_BIT_STRING:{
							return ASN1_STRING_cmp((a->value).bit_string,(b->value).bit_string);
							};break;
		case V_ASN1_OCTET_STRING:{
							return ASN1_STRING_cmp((a->value).octet_string,(b->value).octet_string);
							};break;
		case V_ASN1_PRINTABLESTRING:{
							return ASN1_STRING_cmp((a->value).printablestring,(b->value).printablestring);
							};break;
		case V_ASN1_T61STRING:{
							return ASN1_STRING_cmp((a->value).t61string,(b->value).t61string);
							};break;
		case V_ASN1_IA5STRING:{
							return ASN1_STRING_cmp((a->value).ia5string,(b->value).ia5string);
							};break;
		case V_ASN1_GENERALSTRING:{
							return ASN1_STRING_cmp((a->value).generalstring,(b->value).generalstring);
							};break;
		case V_ASN1_VISIBLESTRING:{
							return ASN1_STRING_cmp((a->value).visiblestring,(b->value).visiblestring);
							};break;
		case V_ASN1_BMPSTRING:{
							return ASN1_STRING_cmp((a->value).bmpstring,(b->value).bmpstring);
							};break;
		case V_ASN1_UNIVERSALSTRING:{
							return ASN1_STRING_cmp((a->value).universalstring,(b->value).universalstring);
							};break;
		case V_ASN1_UTCTIME:{
							return ASN1_STRING_cmp((a->value).utctime,(b->value).utctime);
							};break;
		case V_ASN1_GENERALIZEDTIME:{
							return ASN1_STRING_cmp((a->value).generalizedtime,(b->value).generalizedtime);
							};break;
		case V_ASN1_UTF8STRING:{
							return ASN1_STRING_cmp((a->value).utf8string,(b->value).utf8string);
							};break;
		case V_ASN1_SET:{
							return ASN1_STRING_cmp((a->value).set,(b->value).set);
							};break;
		case V_ASN1_SEQUENCE:{
							return ASN1_STRING_cmp((a->value).sequence,(b->value).sequence);
							};break;
		default: 
				{
				return -1;
				}
		}
	}

int X509_ALGOR_cmp(const X509_ALGOR *a, const X509_ALGOR *b)
	{
	if (ASN1_OBJECT_cmp(a->algorithm,b->algorithm))
		return 1;

	if (ASN1_TYPE_cmp(a->parameter,b->parameter))
		return 1;

	return 0;
	}

int X509AT_ISSUER_SERIAL_cmp(const X509AT_ISSUER_SERIAL *a, const X509AT_ISSUER_SERIAL *b)
	{
	if (GENERAL_NAMES_cmp(a->issuer, b->issuer))
		return 1;

	if (ASN1_STRING_cmp(a->serial,b->serial))
		return 1;

	if (ASN1_STRING_cmp(a->issuerUID,b->issuerUID))
		return 1;

	return 0;
	}

int X509AT_OBJECTDIGESTINFO_cmp(const X509AT_OBJECTDIGESTINFO *a, const X509AT_OBJECTDIGESTINFO *b)
	{
	if (a->digestedObjectType!=b->digestedObjectType)
		return 1;

	if (ASN1_OBJECT_cmp(a->otherObjectTypeID,b->otherObjectTypeID))
		return 1;

	if (X509_ALGOR_cmp(a->digestAlgorithm,b->digestAlgorithm))
		return 1;

	if (ASN1_STRING_cmp(a->objectDigest,b->objectDigest))
		return 1;

	return 0;
	}

int X509AT_ATTCERTISSUER_cmp(const X509AT_ATTCERTISSUER *a,const X509AT_ATTCERTISSUER *b)
	{
	/*
	 Hacemos distincion entre si es tipo V1FORM o V2FORM
	*/
	
	if (a->type==0) /* V1FORM */
		{
		if (GENERAL_NAMES_cmp(a->value.v1Form, b->value.v1Form))
			return 1;
		}
	else		    /* V2FORM */
		{
		if (X509AT_ISSUER_SERIAL_cmp(((a->value).v2Form)->baseCertificateID,((b->value).v2Form)->baseCertificateID))
			return 1;

		if (GENERAL_NAMES_cmp(((a->value).v2Form)->issuerName,((b->value).v2Form)->issuerName))
			return 1;

		if (X509AT_OBJECTDIGESTINFO_cmp(((a->value).v2Form)->objectDigestInfo,((b->value).v2Form)->objectDigestInfo))
			return 1;
		}

	return 0;
	}

int X509AT_HOLDER_cmp(const X509AT_HOLDER *a,const X509AT_HOLDER *b)
	{
	if (X509AT_ISSUER_SERIAL_cmp(a->baseCertificateID,b->baseCertificateID))
		return 1;

	if (GENERAL_NAMES_cmp(a->entityName,b->entityName))
		return 1;

	if (X509AT_OBJECTDIGESTINFO_cmp(a->objectDigestInfo,b->objectDigestInfo))
		return 1;

	return 0;
	}


/************************ FALTA ******************************/
unsigned long X509AT_ATTCERTISSUER_hash(X509AT_ATTCERTISSUER *a)
	{
	return -1;
	}
										
/************************ FALTA ******************************/
unsigned long X509AT_V2FORM_hash(X509AT_V2FORM *a)
	{
	return -1;
	}

/************************ FALTA ******************************/
unsigned long X509AT_HOLDER_hash(X509AT_HOLDER *x)
	{
	return -1;
	}

/**************************************************************************************/

int X509AT_holder_cmp(const X509AT *a, const X509AT *b)
	{
	return(X509AT_HOLDER_cmp(a->cert_info_at->holder,b->cert_info_at->holder));
	}

int X509AT_issuer_cmp(const X509AT *a, const X509AT *b)
	{
	return(X509AT_ATTCERTISSUER_cmp(a->cert_info_at->issuer,b->cert_info_at->issuer));
	}


X509AT_ATTCERTISSUER *X509AT_get_issuer(X509AT *a)
	{
	return(a->cert_info_at->issuer);
	}

unsigned long X509AT_issuer_hash(X509AT *x)
	{
	return(X509AT_ATTCERTISSUER_hash(x->cert_info_at->issuer));
	}

/***********************************************************/
char *X509AT_get_issuer_info(X509AT *a){

	char emisor_issuerName [1024],emisor_BaseCertificateID[1024],emisor_ObjectDigest[1024];
	char *emisor;
	long version;
	int issuerNameFlag=0,BaseCertificateIDFlag=0,ObjectDigestFlag=0;
		
	emisor = (char *) calloc (3072,sizeof(char)); emisor[0]='\0';
		
	version=ASN1_INTEGER_get(a->cert_info_at->version) + 1;

	if ( version == X509AT_VERSION_V1 )
		{
		X509_NAME_oneline(getValue(sk_GENERAL_NAME_value(a->cert_info_at->issuer->value.v1Form,0)),emisor_issuerName,1024);
		sprintf(emisor,"issuer= %s",emisor_issuerName);
		}
	else
		{
		strcpy(emisor_issuerName,"");
		strcpy(emisor_BaseCertificateID,"");
		strcpy(emisor_ObjectDigest,"");
		
		if ( a->cert_info_at->issuer->value.v2Form->issuerName != NULL )
			{
			char issuer_aux[1024];
			X509_NAME_oneline(getValue(sk_GENERAL_NAME_value(a->cert_info_at->issuer->value.v2Form->issuerName,0)),issuer_aux,1024);
			sprintf(emisor_issuerName,"directoryName: %s",issuer_aux);
			}
		
		
		if ( a->cert_info_at->issuer->value.v2Form->baseCertificateID != NULL )
			{
			char serie_text[1000],issuer_aux[800];
			
			sprintf(serie_text,"%ld",ASN1_INTEGER_get(a->cert_info_at->issuer->value.v2Form->baseCertificateID->serial));  
			X509_NAME_oneline(getValue(sk_GENERAL_NAME_value(a->cert_info_at->issuer->value.v2Form->baseCertificateID->issuer,0)),issuer_aux,800);
			sprintf(emisor_BaseCertificateID,"serial number= %s - issuer= %s",serie_text,issuer_aux);
			}

		if ( a->cert_info_at->issuer->value.v2Form->objectDigestInfo!= NULL )
			{
			char object_type[100];
			char object_algorithm[200];
			char *object_aux;
			char *object_hash;
			int nid;

			object_aux=(char *)malloc(a->cert_info_at->issuer->value.v2Form->objectDigestInfo->objectDigest->length+1);
				
			memcpy(object_aux,a->cert_info_at->issuer->value.v2Form->objectDigestInfo->objectDigest->data,a->cert_info_at->issuer->value.v2Form->objectDigestInfo->objectDigest->length);
			
			object_aux[a->cert_info_at->issuer->value.v2Form->objectDigestInfo->objectDigest->length+1]='\0';

			hexToText(object_aux,a->cert_info_at->issuer->value.v2Form->objectDigestInfo->objectDigest->length,&object_hash);

			switch (ASN1_ENUMERATED_get(a->cert_info_at->issuer->value.v2Form->objectDigestInfo->digestedObjectType))
				{
				case OBJECTDIGESTINFO_PUBLICKEY:	{
													sprintf(object_type,"Public Key");
													};break;
				case OBJECTDIGESTINFO_PUBLICKEYCERT:
													{
													sprintf(object_type,"Public Key Certificate");
													};break;
				case OBJECTDIGESTINFO_OTHEROBJECTTYPES:
													{
													if (a->cert_info_at->issuer->value.v2Form->objectDigestInfo->otherObjectTypeID== NULL )
														{
														sprintf(object_type,"Indefinided Type");
														}
													else
														{
														sprintf(object_type,"%s",OBJ_nid2ln(OBJ_obj2nid( a->cert_info_at->issuer->value.v2Form->objectDigestInfo->otherObjectTypeID)));
														}
													
													};break;
				}

			nid=OBJ_obj2nid( a->cert_info_at->issuer->value.v2Form->objectDigestInfo->digestAlgorithm->algorithm);

			sprintf(object_algorithm,"%s",(nid == NID_undef)?"UNKNOWN":OBJ_nid2ln(nid));

			sprintf(emisor_ObjectDigest," Hash Information:\n Object Type= %s\n Hash Algorithm= %s\n Onject Hash= %s",object_type,object_algorithm,object_hash);
			}

		if (strcmp(emisor_issuerName,""))		 issuerNameFlag=1;
		if (strcmp(emisor_BaseCertificateID,"")) BaseCertificateIDFlag=1;
		if (strcmp(emisor_ObjectDigest,""))		 ObjectDigestFlag=1;
		
		if ((issuerNameFlag && BaseCertificateIDFlag) || (issuerNameFlag && ObjectDigestFlag))
				sprintf(emisor_issuerName,"%s\n",emisor_issuerName);
		if (BaseCertificateIDFlag && ObjectDigestFlag) 
				sprintf(emisor_BaseCertificateID,"%s\n",emisor_BaseCertificateID);
		//sprintf(emisor_ObjectDigest,"%s\n",emisor_ObjectDigest);

		sprintf(emisor,"%s%s%s",emisor_issuerName,emisor_BaseCertificateID,emisor_ObjectDigest);
		}
	return emisor;
}

/***********************************************************/
char *X509AT_get_att_info(X509AT *a){

	int i,j;
	char *atributos=(char *)malloc(3000*sizeof(char));
	X509AT_ATTRIBUTE *at;
	sprintf(atributos,"");
	
	
	for (i=0;i<sk_X509AT_ATTRIBUTE_num(a->cert_info_at->attributes);i++)
		{
		ASN1_OBJECT *asn1_object_aux;
		char objtmp[80];
		int nid;

		at=sk_X509AT_ATTRIBUTE_value(a->cert_info_at->attributes,i);
		asn1_object_aux=at->object;

		//OBJECT ATTRIBUTE
		nid=OBJ_obj2nid(asn1_object_aux);
		OBJ_obj2txt(objtmp, sizeof objtmp, asn1_object_aux, 1);

		
			sprintf(atributos,"%s=========== Attribute Data number %i ===========\n",atributos,i);
			sprintf(atributos,"%sOID Data: Id=%s (OBJECT ID =%s)\n",atributos,OBJ_nid2ln(nid),objtmp);
			sprintf(atributos,"%sSET[C] = %i elements\n",atributos,sk_ASN1_TYPE_num((at->value).set));
			

		for (j=0;j<sk_ASN1_TYPE_num((at->value).set);j++)
			{
			char value_aux[1000],*valorEncontrado;
			ASN1_TYPE *asn1_type_aux;
			ASN1_STRING *asn1_string_aux;
			X509AT_ATTRIBUTE *at;

			at=sk_X509AT_ATTRIBUTE_value(a->cert_info_at->attributes,i);
			asn1_type_aux=sk_ASN1_TYPE_value((at->value).set,j);
			
			asn1_string_aux=(ASN1_STRING *)asn1_type_aux->value.ptr;

			valorEncontrado=(char *)malloc(asn1_string_aux->length+1);
			memcpy(valorEncontrado,asn1_string_aux->data,asn1_string_aux->length);
	
			valorEncontrado[asn1_string_aux->length]='\0';
			
			sprintf(value_aux,"    Value %i= %s\n",j,valorEncontrado);
		
			strcat(atributos,value_aux);
				
		}
			strcat(atributos,"\n");
	}
	return atributos;
}
/***********************************************************/

char *X509AT_get_holder_info(X509AT *a){

	char emisor_issuerName [1024],emisor_BaseCertificateID[1024],emisor_ObjectDigest[1024];
	char *emisor;
	long version;
	int issuerNameFlag=0,BaseCertificateIDFlag=0,ObjectDigestFlag=0;
	
	emisor = (char *) calloc (3072,sizeof(char)); emisor[0]='\0';
		
	version=ASN1_INTEGER_get(a->cert_info_at->version) + 1;

		strcpy(emisor_issuerName,"");
		strcpy(emisor_BaseCertificateID,"");
		strcpy(emisor_ObjectDigest,"");
					
		if ( a->cert_info_at->holder->entityName != NULL )
			{
			char issuer_aux[1024];
			X509_NAME_oneline(getValue(sk_GENERAL_NAME_value(a->cert_info_at->holder->entityName,0)),issuer_aux,1024);
			sprintf(emisor_issuerName,"directoryName: %s",issuer_aux);
			}
		
		if ( a->cert_info_at->holder->baseCertificateID != NULL )
			{
			char serie_text[1000],issuer_aux[800];
			
			sprintf(serie_text,"%ld",ASN1_INTEGER_get(a->cert_info_at->holder->baseCertificateID->serial));  
			X509_NAME_oneline(getValue(sk_GENERAL_NAME_value(a->cert_info_at->holder->baseCertificateID->issuer,0)),issuer_aux,800);
			sprintf(emisor_BaseCertificateID,"serial number= %s - holder= %s",serie_text,issuer_aux);
			}

		if ( a->cert_info_at->holder->objectDigestInfo!= NULL )
			{
			char object_type[100];
			char object_algorithm[200];
			char *object_aux;
			char *object_hash;
			int nid;

			object_aux=(char *)malloc(a->cert_info_at->holder->objectDigestInfo->objectDigest->length+1);
				
			memcpy(object_aux,a->cert_info_at->holder->objectDigestInfo->objectDigest->data,a->cert_info_at->holder->objectDigestInfo->objectDigest->length);
			object_aux[a->cert_info_at->holder->objectDigestInfo->objectDigest->length+1]='\0';
			hexToText(object_aux,a->cert_info_at->holder->objectDigestInfo->objectDigest->length,&object_hash);
		
			switch (ASN1_ENUMERATED_get(a->cert_info_at->holder->objectDigestInfo->digestedObjectType))
				{
				case OBJECTDIGESTINFO_PUBLICKEY:	{
													sprintf(object_type,"Public Key");
													};break;
				case OBJECTDIGESTINFO_PUBLICKEYCERT:
													{
													sprintf(object_type,"Public Key Certificate");
													};break;
				case OBJECTDIGESTINFO_OTHEROBJECTTYPES:
													{
													if (a->cert_info_at->holder->objectDigestInfo->otherObjectTypeID== NULL )
														{
														sprintf(object_type,"Indefinided Type");
														}
													else
														{
														sprintf(object_type,"%s",OBJ_nid2ln(OBJ_obj2nid( a->cert_info_at->holder->objectDigestInfo->otherObjectTypeID)));
														}
													
													};break;
				}

			nid=OBJ_obj2nid( a->cert_info_at->holder->objectDigestInfo->digestAlgorithm->algorithm);
			sprintf(object_algorithm,"%s",(nid == NID_undef)?"UNKNOWN":OBJ_nid2ln(nid));

			sprintf(emisor_ObjectDigest," Hash Information:\n Object Type= %s\n Hash Algorithm= %s\n Onject Hash= %s",object_type,object_algorithm,object_hash);
			}

		if (strcmp(emisor_issuerName,""))		 issuerNameFlag=1;
		if (strcmp(emisor_BaseCertificateID,"")) BaseCertificateIDFlag=1;
		if (strcmp(emisor_ObjectDigest,""))		 ObjectDigestFlag=1;
		
		if ((issuerNameFlag && BaseCertificateIDFlag) || (issuerNameFlag && ObjectDigestFlag))
				sprintf(emisor_issuerName,"%s\n",emisor_issuerName);
		if (BaseCertificateIDFlag && ObjectDigestFlag) 
				sprintf(emisor_BaseCertificateID,"%s\n",emisor_BaseCertificateID);
		
		sprintf(emisor,"%s%s%s",emisor_issuerName,emisor_BaseCertificateID,emisor_ObjectDigest);
		
	return emisor;
}


int X509AT_V2FORM_cmp(const X509AT_V2FORM *a,const X509AT_V2FORM *b)
	{
	if (X509AT_ISSUER_SERIAL_cmp(a->baseCertificateID,b->baseCertificateID))
		return 1;

	if (GENERAL_NAMES_cmp(a->issuerName,b->issuerName))
		return 1;

	if (X509AT_OBJECTDIGESTINFO_cmp(a->objectDigestInfo,b->objectDigestInfo))
		return 1;

	return 0;
	}


X509AT_HOLDER *X509AT_get_holder(X509AT *a)
	{
	return(a->cert_info_at->holder);
	}

ASN1_INTEGER *X509AT_get_serialNumber(X509AT *a)
	{
	return(a->cert_info_at->serialNumber);
	}

unsigned long X509AT_holder_hash(X509AT *x)
	{
	return(X509AT_HOLDER_hash(x->cert_info_at->holder));
	}


#ifndef OPENSSL_NO_SHA
/* Compare two certificates: they must be identical for
 * this to work. NB: Although "cmp" operations are generally
 * prototyped to take "const" arguments (eg. for use in
 * STACKs), the way X509 handling is - these operations may
 * involve ensuring the hashes are up-to-date and ensuring
 * certain cert information is cached. So this is the point
 * where the "depth-first" constification tree has to halt
 * with an evil cast.
 */


/*************************************************************************************

BEGIN_MODIFICADO por mi 29/07/2003
  
int X509AT_cmp(const X509AT *a, const X509AT *b)
{
	X509AT_check_purpose((X509AT *)a, -1, 0);
	X509AT_check_purpose((X509AT *)b, -1, 0);

	return memcmp(a->sha1_hash, b->sha1_hash, SHA_DIGEST_LENGTH);
}
**************************************************************************************/

int X509AT_cmp(const X509AT *a, const X509AT *b)
/*
 Se hace un hash a cada certificado y se compara para comprobar que ambos 
 son el mismo
*/
{
	X509AT_digest(a, EVP_sha1(),(unsigned char *)a->sha1_hash, NULL);
	X509AT_digest(b, EVP_sha1(),(unsigned char *)b->sha1_hash, NULL);

	return memcmp(a->sha1_hash, b->sha1_hash, SHA_DIGEST_LENGTH);
}

#endif



/*************************************************************************************

BEGIN_ANYADIDO por mi 07/05/2003
  
- Funciones para hacer el hash del certificado
**************************************************************************************/

int ASN1_OBJECT_oneline(ASN1_OBJECT *a,char **out)
	/*
	 Retorna la longitud de la cadena devuelta en out, compuesta por la concatenacion
	 de sn, ln, nid y data.
	*/
	{
	char *temp,*desplazador;
	int longitud=0;
	int retorno=0;

	if (a->sn!=NULL)
		longitud+=strlen(a->sn)+1;

	if (a->ln!=NULL)
		longitud+=strlen(a->ln)+1;

	longitud+=sizeof(int);

	longitud+=a->length;

	temp=(char *)OPENSSL_malloc(longitud);

	desplazador=temp;

	/*
	 Vamos moviendo desplazador para ir copiando cada trozo a continuacion uno del otro
	 en la cadena temp
	*/
	if (a->sn!=NULL)
		{
		memcpy(desplazador,a->sn,strlen(a->sn)+1);
		desplazador+=strlen(a->sn)+1;
		}
	if (a->ln!=NULL)
		{
		memcpy(desplazador,a->ln,strlen(a->ln)+1);
		desplazador+=strlen(a->ln)+1;
		}
	
	memcpy(desplazador,(char *)a->nid,sizeof(int));
	desplazador+=sizeof(int);
	
	if (a->length!=0)
		{
		memcpy(desplazador,(char *)a->data,a->length);
		desplazador+=a->length;
		}

	*out=temp;
	return longitud;
	}

/*************************************************************************************/

int ASN1_STRING_oneline(ASN1_STRING *a,char **out)
	/*
	 Retorna la longitud de la cadena devuelta en out, compuesta por data.
	*/
	{
	char *temp;
	int longitud=0;

	longitud=a->length;

	temp=(char *)OPENSSL_malloc(longitud);

	memcpy(temp,a->data,a->length);
	
	*out=temp;

	return longitud;
	}

/*************************************************************************************

END_ANYADIDO por mi 07/05/2003
  
**************************************************************************************/

void * getValue(GENERAL_NAME *gn)
	{
	//Hemos de hacer esto puesto que estamos tratando con una "union"
	switch(gn->type)
		{
		case GEN_OTHERNAME:{
							return gn->d.otherName;
							};break;

		case GEN_EMAIL:{
							return gn->d.rfc822Name;
							};break;
		case GEN_DNS:{
							return gn->d.dNSName;
							};break;
		case GEN_X400:{
							return gn->d.x400Address;
							};break;
		case GEN_DIRNAME:{
							return gn->d.directoryName;
							};break;
		case GEN_EDIPARTY:{
							return gn->d.ediPartyName;
							};break;
		case GEN_URI	:{
							return gn->d.uniformResourceIdentifier;
							};break;
		case GEN_IPADD:{
							return gn->d.iPAddress;
							};break;
		case GEN_RID	:{
							return gn->d.registeredID;
							};break;
		default:{
				return NULL;
				};break;
		}
	}

/*********************************************************
 Nombre:     hexToText
 
 Parametros:	hex: Cadena en hexadecimal a convertir
				length: longitud de la cadena en hexadecimal
				text: Cadena de texto resultado

 Descripcin:	Esta funcion convierte una cadena en hexadecimal a una cadena de texto
				Devuelve la longitud de la cadena
**********************************************************/

int hexToText(const char *hex,int length, char **text)
	{
	int i=0;
	char aux[20];
	
	*text=(char *)malloc(10*length);
	
	strcpy(*text,"");

	for (i=0;i<length;i++)
		{
		sprintf(aux,"%08X ",hex[i]);
		strcat(*text,aux);
		}

	return strlen(*text);
	}


int X509AT_print(BIO *bp, X509AT *x)
{
	return X509AT_print_ex(bp, x, XN_FLAG_COMPAT, X509_FLAG_COMPAT);
}



int X509AT_print_ex(BIO *bp, X509AT *x, unsigned long nmflags, unsigned long cflag)
	{
	long l;
	int ret=0,i;
	char *m=NULL,mlch = ' ';
	int nmindent = 0;
	X509AT_CINF *ci;
	ASN1_INTEGER *bs;
	EVP_PKEY *pkey=NULL;
	const char *neg;
	ASN1_STRING *str=NULL;

	if((nmflags & XN_FLAG_SEP_MASK) == XN_FLAG_SEP_MULTILINE) {
			mlch = '\n';
			nmindent = 12;
	}

	if(nmflags == X509_FLAG_COMPAT)
		nmindent = 16;

	ci=x->cert_info_at;
	if(!(cflag & X509_FLAG_NO_HEADER))
		{
		if (BIO_write(bp,"Attribute Certificate:\n",23) <= 0) goto err;
		if (BIO_write(bp,"    Data:\n",10) <= 0) goto err;
		}
	if(!(cflag & X509_FLAG_NO_VERSION))
		{
		l=X509AT_get_version(x);
		if (BIO_printf(bp,"%8sVersion: %lu (0x%lx)\n","",l+1,l) <= 0) goto err;
		}
	if(!(cflag & X509_FLAG_NO_SERIAL))
		{

		if (BIO_write(bp,"        Serial Number:",22) <= 0) goto err;

		bs=X509AT_get_serialNumber(x);
		if (bs->length <= 4)
			{
			l=ASN1_INTEGER_get(bs);
			if (l < 0)
				{
				l= -l;
				neg="-";
				}
			else
				neg="";
			if (BIO_printf(bp," %s%lu (%s0x%lx)\n",neg,l,neg,l) <= 0)
				goto err;
			}
		else
			{
			neg=(bs->type == V_ASN1_NEG_INTEGER)?" (Negative)":"";
			if (BIO_printf(bp,"\n%12s%s","",neg) <= 0) goto err;

			for (i=0; i<bs->length; i++)
				{
				if (BIO_printf(bp,"%02x%c",bs->data[i],
					((i+1 == bs->length)?'\n':':')) <= 0)
					goto err;
				}
			}

		}

	if(!(cflag & X509_FLAG_NO_SIGNAME))
		{
		if (BIO_printf(bp,"%8sSignature Algorithm: ","") <= 0) 
			goto err;
		if (i2a_ASN1_OBJECT(bp, ci->signature->algorithm) <= 0)
			goto err;
		if (BIO_puts(bp, "\n") <= 0)
			goto err;
		}
	if(!(cflag & X509_FLAG_NO_ISSUER))
		{
		 if (BIO_printf(bp,"        Issuer:\n         %s\n",X509AT_get_issuer_info(x)) <= 0) goto err; 
		}
	if(!(cflag & X509_FLAG_NO_VALIDITY))
		{
		if (BIO_write(bp,"        Validity\n",17) <= 0) goto err;
		if (BIO_write(bp,"            Not Before: ",24) <= 0) goto err;
		if (!ASN1_TIME_print(bp,X509AT_get_notBefore(x))) goto err;
		if (BIO_write(bp,"\n            Not After : ",25) <= 0) goto err;
		if (!ASN1_TIME_print(bp,X509AT_get_notAfter(x))) goto err;
		if (BIO_write(bp,"\n",1) <= 0) goto err;
		}
	if(!(cflag & X509_FLAG_NO_SUBJECT))
		{
		 if (BIO_printf(bp,"        Holder:\n         %s\n",X509AT_get_holder_info(x)) <= 0) goto err; 
		}
	if(!(cflag & X509_FLAG_NO_ATTRIBUTES))
		{
		 if (BIO_printf(bp,"        Attributes:\n            %s\n",X509AT_getOneLine_attributes(x)) <= 0) goto err; 
		}

	if (!(cflag & X509_FLAG_NO_EXTENSIONS))
		X509V3_extensions_print(bp, "X509v3 extensions",ci->extensions, cflag, 8);

	if(!(cflag & X509_FLAG_NO_SIGDUMP))
		{
		if(X509_signature_print(bp, x->sig_alg, x->signature) <= 0) goto err;
		}
	if(!(cflag & X509_FLAG_NO_AUX))
		{
		if (!X509_CERT_AUX_print(bp, x->aux, 0)) goto err;
		}
	ret=1;
err:
	if (str != NULL) ASN1_STRING_free(str);
	if (m != NULL) OPENSSL_free(m);
	return(ret);
	}


int X509AT_digestF(const X509AT *data,const EVP_MD *type, unsigned char *md,unsigned int *len)
	{
		return(ASN1_item_digest(ASN1_ITEM_rptr(X509AT),type,(char *)data,md,len));
	}

/**********************************/

int X509AT_alias_set1(X509AT *x, unsigned char *name, int len)
{
	X509_CERT_AUX *aux;
	
	if(!x) return 0;
	if(!x->aux && !(x->aux = X509_CERT_AUX_new())) return 0;
	aux = x->aux;
	
	if(!aux->alias && !(aux->alias = ASN1_UTF8STRING_new())) return 0;
	return ASN1_STRING_set(aux->alias, name, len);
}

unsigned char *X509AT_alias_get0(X509AT *x, int *len)
{
	if(!x->aux || !x->aux->alias) return NULL;
	if(len) *len = x->aux->alias->length;
	return x->aux->alias->data;
}

int X509AT_add1_trust_object(X509AT *x, ASN1_OBJECT *obj)
{
	X509_CERT_AUX *aux;
	ASN1_OBJECT *objtmp;
	if(!(objtmp = OBJ_dup(obj))) return 0;

	if(!x) return 0;
	if(!x->aux && !(x->aux = X509_CERT_AUX_new())) return 0;
	aux = x->aux;

	if(!aux->trust
		&& !(aux->trust = sk_ASN1_OBJECT_new_null())) return 0;
	return sk_ASN1_OBJECT_push(aux->trust, objtmp);
}

int X509AT_add1_reject_object(X509AT *x, ASN1_OBJECT *obj)
{
	X509_CERT_AUX *aux;
	ASN1_OBJECT *objtmp;
	if(!(objtmp = OBJ_dup(obj))) return 0;
	
	if(!x) return 0;
	if(!x->aux && !(x->aux = X509_CERT_AUX_new())) return 0;
	aux = x->aux;

	if(!aux->reject
		&& !(aux->reject = sk_ASN1_OBJECT_new_null())) return 0;
	return sk_ASN1_OBJECT_push(aux->reject, objtmp);
}

void X509AT_trust_clear(X509AT *x)
{
	if(x->aux && x->aux->trust) {
		sk_ASN1_OBJECT_pop_free(x->aux->trust, ASN1_OBJECT_free);
		x->aux->trust = NULL;
	}
}

void X509AT_reject_clear(X509AT *x)
{
	if(x->aux && x->aux->reject) {
		sk_ASN1_OBJECT_pop_free(x->aux->reject, ASN1_OBJECT_free);
		x->aux->reject = NULL;
	}
}

char *X509AT_getOneLine_attributes(X509AT *a){

	int i;
	char *atributos=(char *)malloc(3000*sizeof(char));
	X509AT_ATTRIBUTE *at;
	sprintf(atributos,"");
	
	if (a==NULL) return NULL;
	

	for (i=0;i<sk_X509AT_ATTRIBUTE_num(a->cert_info_at->attributes);i++)
		{
		ASN1_OBJECT *asn1_object_aux;
		char objtmp[80];
		int nid;

		at=sk_X509AT_ATTRIBUTE_value(a->cert_info_at->attributes,i);
		asn1_object_aux=at->object;

		//OBJECT ATTRIBUTE
		nid=OBJ_obj2nid(asn1_object_aux);
		OBJ_obj2txt(objtmp, sizeof objtmp, asn1_object_aux, 1);

		sprintf(atributos,"%s%s:",atributos,objtmp);
		
	}
	return atributos;
}


/***********************************************************/

int X509AT_check_purpose(X509AT *xAT, int id, int ca)
{
	int idx;
	const X509_PURPOSE *pt;
/*	if(!(xAT->ex_flags & EXFLAG_SET)) {
		CRYPTO_w_lock(CRYPTO_LOCK_X509);
		x509v3_cache_extensions(xAT);
		CRYPTO_w_unlock(CRYPTO_LOCK_X509);
	}*/
	if(id == -1) return 1;
	idx = X509_PURPOSE_get_by_id(id);
	if(idx == -1) return -1;
	pt = X509_PURPOSE_get0(idx);
	return pt->check_purpose(pt, (X509 *)xAT, ca);
}


